; Process_Suspend
; ----------------
; This is an AutoIt script file, use AutoIt to run this script
; AutoIt Version: 3.3.14.0
;


; Author: Xandy
; Uses: The Kandy Man _ProcessSuspend, Resume functions
;
; This software uses Core Temp External Application to read CPU Temperature!
; I downloaded Core Temp from here, there were no ads or installers:
; http://core-temp.en.lo4d.com/download

; Function
; Configure CPU Tempaturate Suspend and Resume Process_List Temperature values
; Configure List of Processes to Suspend and Resume
; Toggle Process_List Suspend State based a min max CPU temperature parameters

; I found how to suspend processes and was able to make it through a Compute Missing Matches with VisualSMF.
; I had to manuelly toggle the process (hotkeys: 0, 1) suspended state.  I also had to switch the process that I was suspending about 1/2 way through.
; I though this is good if I can just read my cpu Temperature progmatically.  The very first thing I did was uninstal Core Temp.
; I thought I'm going to be getting superior software through my mobo provider Asus.  A fucking day later I reinstal Core Temp and read the Gui control values into AutoIt.
;

; Todo: X is done
; - Might free program work load at runtime:
; X - Replace aControl with a reading of aControl to aData
; X - aData offset to start process_list
; X - Make Edit and Use mode to read in data once then use
; - Process list to array aProcess_list[..][name, instance, state returned]
; - Populate list box with those columes
;

#include "Process_Suspend_udf.au3"; Author: The Kandy Man
#include <GuiConstants.au3>
#include <GuiListView.au3>
#include <Misc.au3>
#include <File.au3>
;#RequireAdmin

; Global
Global $gsCoretemp_win_title = "Core Temp"
Global $gCoretemp_gui_temp_control = "Static53"; The Core Temp Gui control to read to obtain cpu temp

; Paths
Global $gPath_settings = @ScriptDir & "\Settings\"


Global $giSettings_offset_before_process_list = 3

; Control Data
Global Enum $eControl_data, $eControl_label, $eControl_type, $eControl_data_val, $eControl_tip;
Global $giControl_data_max= 5

; Main Gui Control Enum
Global Enum $eidAction_group, _
		$eidAction_state, _
		$eidAction_again, _
		$eidAction_state_switch, _
		$eidCore_temp_group, _
		$eidCore_temp_edit_status, _
		$eidCore_temp_high, _
		$eidCore_temp_low, _
		$eidCore_temp_read_timer_max, _
		$eidProcess_list, _
		$eidProcess_add, _
		$eidProcess_remove

; Store data once per edit, not request from Gui control each compare
Global Enum $eData_suspend, $eData_resume, $eData_temp_check_sec

; Action State
Global Enum $eAction_state_none, $eAction_state_suspend, $eAction_state_resume
Global Enum $eAction_state_name, $eAction_state_color
Global $gaAction_state = [["No Action", 0xF0F0F0], ["Suspend", 0xfb0000], ["Resume", 0x00fb00]]

; Edit Mode State
Global Enum $eEdit_state_edit, $eEdit_state_react
Global $gaEdit_state = [["Monitor", 0xfb0000], ["Edit", 0x00fb00]]

; Select from Listview with DoubleClick
Global $gMylistbox = 0, $gMylistbox_msg = 0
GUIRegisterMsg($WM_COMMAND, "_WM_COMMAND"); Select from listview with DoubleClick

Global $ghProcess_list = 0
Global $ghGui = 0

OnAutoItExitRegister("_exit")
opt("GuiCloseonEsc", 0)

main()
Func main()
	; Gui Window and Rect
	$ghGui = GUICreate(@ScriptName, 350, 360)
	$gui_rect = WinGetPos($ghGui)

	; Gui Menus
	Local $menu_max = 2
	Local Enum $eMenu_file, $eMenu_help;, $eMenu_settings
	Local $aMenu[$menu_max]

	$aMenu[$eMenu_file] = GUICtrlCreateMenu("File")
	$menu_file_save = GUICtrlCreateMenuItem("Save", $aMenu[$eMenu_file])
	$menu_file_load = GUICtrlCreateMenuItem("Load", $aMenu[$eMenu_file])
	$menu_file_exit = GUICtrlCreateMenuItem("Exit", $aMenu[$eMenu_file])
	$aMenu[$eMenu_help] = GUICtrlCreateMenu("Help")
	$menu_help_about = GUICtrlCreateMenuItem("About", $aMenu[$eMenu_help])
	;$aMenu[$eMenu_settings] = GUICtrlCreateMenu("Settings")
	;$menu_settings = GUICtrlCreateMenuItem("Settings", $aMenu[$eMenu_settings])

	Local $iAction_state = $eAction_state_none; default action_state
	Local $iAction_state_last = $iAction_state
	Local $iEdit_state = $eEdit_state_edit

	Local $aControl = [[0, "", "Group", "", ""], _; Action Group
			[0, "", "label Center", "", "How this Application is attempting to handle Process_List"], _
			[0, "", "Button", "", "Repeat Last Action on Process_List"], _
			[0, "", "Button Multiline", "", "Toggle Process Suspend State"], _
			[0, "", "Group", "", ""], _; Core Temp Group [..]
			[0, "Monitor   Temp", "Button", "", "Toggle Button:" & @CRLF & "1. Suspend Process_List based on CPU Core Temp" & @CRLF & "2. Edit values"], _
			[0, "Suspend Temp", "Input", "", "CPU Temperature to Suspend Processes_List"&@crlf&"C or F is set by Core Temp display"], _
			[0, "Resume  Temp", "Input", "", "CPU Temperature to Resume Processes_List"&@crlf&"C or F is set by Core Temp display"], _
			[0, "Check CPU (sec)", "Input", "", "Amount of seconds to check CPU Temperature"], _
			[0, "Process List:", "listview", "", "List of Processes to Suspend or Resume"], _
			[0, "", "Button", "", "Add a Process to List"], _
			[0, "", "Button", "", "Remove Selected Process from List" & @CRLF & "CTRL + Click to Empty Process_List"] _
			]
	Local $control_max = UBound($aControl)

	;label_control(ByRef $aControl, $iControl_id, $sLabel, $label_x, $label_y, $label_w, $label_h, $sData_control_type, $data_x, $data_y, $data_w, $data_h, $data_value = "")
	; Action State and Toggle Switch
	$x = 10
	$y = 5
	label_control($aControl, $eidAction_group, $aControl[$eidAction_group][$eControl_label], 800, $y, 30, 20, $aControl[$eidAction_group][$eControl_type], $x, $y, 155, 80, "Process Suspend")
	label_control($aControl, $eidAction_state, $aControl[$eidAction_state][$eControl_label], 800, $y, 30, 20, $aControl[$eidAction_state][$eControl_type], $x + 10, $y + 20, 80, 25, $gaAction_state[$iAction_state][$eAction_state_name])
	label_control($aControl, $eidAction_again, $aControl[$eidAction_again][$eControl_label], 800, $y, 30, 20, $aControl[$eidAction_again][$eControl_type], $x + 10, $y + 46, 80, 25, "Do Again")
	label_control($aControl, $eidAction_state_switch, $aControl[$eidAction_state_switch][$eControl_label], 1000, $y, 0, 0, $aControl[$eidAction_state_switch][$eControl_type], $x + 100, $y + 20, 45, 51, "Switch Action")
	; CPU Temp Colume
	$x = $gui_rect[2] - 165
	$xpad = 90
	$y = 5
	$z = 25
	; Core Temp Group
	label_control($aControl, $eidCore_temp_group, $aControl[$eidCore_temp_group][$eControl_label], 800, $y, 0, 0, $aControl[$eidCore_temp_group][$eControl_type], $x - 15, $y, 165, $y + $z * 5, "  Core Temp")
	label_control($aControl, $eidCore_temp_edit_status, $aControl[$eidCore_temp_edit_status][$eControl_label], $x, $y + $z, 83, 20, $aControl[$eidCore_temp_edit_status][$eControl_type], $x + $xpad, $y + $z, 50, 21, $gaEdit_state[$eEdit_state_edit][$eAction_state_name])
	label_control($aControl, $eidCore_temp_high, $aControl[$eidCore_temp_high][$eControl_label], $x, $y + $z * 2, 83, 20, $aControl[$eidCore_temp_high][$eControl_type], $x + $xpad, $y + $z * 2, 50, 20)
	label_control($aControl, $eidCore_temp_low, $aControl[$eidCore_temp_low][$eControl_label], $x, $y + $z * 3, 83, 20, $aControl[$eidCore_temp_low][$eControl_type], $x + $xpad, $y + $z * 3, 50, 20)
	label_control($aControl, $eidCore_temp_read_timer_max, $aControl[$eidCore_temp_read_timer_max][$eControl_label], $x, $y + $z * 4, 83, 20, $aControl[$eidCore_temp_read_timer_max][$eControl_type], $x + $xpad, $y + $z * 4, 50, 20)

	; Process List Area
	$y = 150
	label_control($aControl, $eidProcess_list, $aControl[$eidProcess_list][$eControl_label], 5, $y, 83, 20, $aControl[$eidProcess_list][$eControl_type], 5, $y + 15, $gui_rect[2] - 20, $gui_rect[3] - $y - 65, "Process_Name")
	label_control($aControl, $eidProcess_add, $aControl[$eidProcess_add][$eControl_label], 800, $y, 0, 0, $aControl[$eidProcess_add][$eControl_type], 80, $y - 7, 75, 20, "Add Process")
	label_control($aControl, $eidProcess_remove, $aControl[$eidProcess_remove][$eControl_label], 800, $y, 0, 0, $aControl[$eidProcess_remove][$eControl_type], 160, $y - 7, 95, 20, "Remove Process")
	GUISetState()

	settings_load($aControl)
	Local $aData = control_cpu_temp($aControl, $gui_enable)

	Local $timer_core_temp
	$ghProcess_list = GUICtrlGetHandle($aControl[$eidProcess_list][$eControl_data])

	; Find the Core Temp External App
	Local $bCore_temp_found = 0
	$hCoretemp = core_temp_get_handle($gsCoretemp_win_title)
	If $hCoretemp <> -1 Then $bCore_temp_found = 1

	; Misc Default Gui Control Settings
	GUICtrlSetFont($aControl[$eidAction_state][$eControl_data], 12, 400); Action State Label Big Font
	_GUICtrlListView_SetColumnWidth($ghProcess_list, 0, $gui_rect[2] - 15); Process_List Process_Name Great Width [..>
	;GUICtrlSetState($aControl[$eidProcess_list][$eControl_data], $gui_focus)
	GUICtrlSetBkColor($aControl[$eidCore_temp_edit_status][$eControl_data], $gaEdit_state[$iEdit_state][$eAction_state_color])

	Do
		$msg = GUIGetMsg()
		Switch $msg
			; Menu Actions
			Case $menu_file_exit
				$msg = $gui_event_close
			Case $menu_file_save
				DirCreate($gPath_settings)
				$filename = FileSaveDialog("Save Settings", $gPath_settings, "Text (*.txt)", Default, "", $ghGui)
				If @error = 0 Then
					settings_save($aControl, $filename)
				EndIf
			Case $menu_file_load
				$filename = FileOpenDialog("Load Settings", $gPath_settings, "Text (*.txt)", Default, "", $ghGui)
				If @error = 0 Then
					settings_load($aControl, $filename)
				EndIf
			Case $menu_help_about
				about_dialog()
				;Case $menu_settings
				;settings_dialog($aSettings)

				; Edit Button CPU Temperature thresholds
			Case $aControl[$eidCore_temp_edit_status][$eControl_data]
				$aData = edit_state_toggle($aControl, $iEdit_state)

			Case $aControl[$eidAction_again][$eControl_data]
				action_state_switch($aControl, $iAction_state)
				; Action State Toggle Button
			Case $aControl[$eidAction_state_switch][$eControl_data]
				If $iAction_state = $eAction_state_suspend Then
					$iAction_state = $eAction_state_resume
				Else
					$iAction_state = $eAction_state_suspend
				EndIf
				$iAction_state_last = action_state_switch($aControl, $iAction_state)

			Case $aControl[$eidProcess_add][$eControl_data]
				$aProcess_list = ProcessList()
				$new_process = window_list($aProcess_list, "Select Process")
				If $new_process <> -1 Then
					process_listview_add($aControl[$eidProcess_list][$eControl_data], $new_process)
				EndIf
			Case $aControl[$eidProcess_remove][$eControl_data]
				If _IsPressed(11) Then
					_GUICtrlListView_DeleteAllItems($ghProcess_list)
				Else
					process_list_remove()
					_GUICtrlListView_DeleteItemsSelected($ghProcess_list)
				EndIf
		EndSwitch

		If $bCore_temp_found = 1 And $iEdit_state = $eEdit_state_react Then
			If TimerDiff($timer_core_temp) > $aData[$eData_temp_check_sec] Then
				$coretemp = Int(ControlGetText($hCoretemp, "", $gCoretemp_gui_temp_control))
				;If $coretemp >= GUICtrlRead($aControl[$eidCore_temp_high][$eControl_data]) Then; 0
				If $coretemp >= $aData[$eData_suspend] Then; 0
					$iAction_state = $eAction_state_suspend
					;ElseIf $coretemp <= GUICtrlRead($aControl[$eidCore_temp_low][$eControl_data]) Then; 1
				ElseIf $coretemp <= $aData[$eData_resume] Then; 1
					$iAction_state = $eAction_state_resume
				EndIf

				If $iAction_state_last <> $iAction_state Then
					$iAction_state_last = action_state_switch($aControl, $iAction_state)
				EndIf
				$timer_core_temp = TimerInit()
			EndIf; TimerDiff($timer_core_temp) > aData[timer]
		EndIf
	Until $msg = $gui_event_close
	settings_save($aControl)
EndFunc   ;==>main
;_exit()

Func action_state_switch(ByRef $aControl, $iAction_state)
	GUICtrlSetBkColor($aControl[$eidAction_state][$eControl_data], $gaAction_state[$iAction_state][$eAction_state_color]); Light Control Indictator
	Switch $iAction_state
		Case $eAction_state_suspend
			process_list_suspend($aControl)
		Case $eAction_state_resume
			process_list_resume($aControl)
	EndSwitch
	Return $iAction_state
EndFunc   ;==>action_state_switch

Func settings_save($aControl, $filename = $gPath_settings & "Settings.txt")
	If $filename <> $gPath_settings & "Settings.txt" Then
		If FileExists($filename) Then
			$x = MsgBox($MB_OKCANCEL, "File Already Exists", "File Already Exists" & @CRLF & "Overwrite File: " & @CRLF & $filename & @CRLF & "???", Default, $ghGui)
			If $x <> $IDOK Then
				Return
			EndIf
		EndIf
	EndIf
	$file = FileOpen($filename, BitOR($fo_createpath, $fo_overwrite))
	If $file <> -1 Then
		; Settings like Min, Max Temp
		FileWriteLine($file, GUICtrlRead($aControl[$eidCore_temp_high][$eControl_label]) & ": " & GUICtrlRead($aControl[$eidCore_temp_high][$eControl_data]))
		FileWriteLine($file, GUICtrlRead($aControl[$eidCore_temp_low][$eControl_label]) & ": " & GUICtrlRead($aControl[$eidCore_temp_low][$eControl_data]))
		FileWriteLine($file, GUICtrlRead($aControl[$eidCore_temp_read_timer_max][$eControl_label]) & ": " & GUICtrlRead($aControl[$eidCore_temp_read_timer_max][$eControl_data]))

		; Write Process Name List
		For $i = 0 To _GUICtrlListView_GetItemCount($ghProcess_list) - 1
			FileWriteLine($file, _GUICtrlListView_GetItemText($ghProcess_list, $i))
		Next
	EndIf
	FileClose($file)
EndFunc   ;==>settings_save

Func settings_load(ByRef $aControl, $filename = $gPath_settings & "Settings.txt")
	$file = FileOpen($filename)
	If $file <> -1 Then
		GUICtrlSetData($aControl[$eidCore_temp_high][$eControl_data], read_chunk($file))
		GUICtrlSetData($aControl[$eidCore_temp_low][$eControl_data], read_chunk($file))
		GUICtrlSetData($aControl[$eidCore_temp_read_timer_max][$eControl_data], read_chunk($file))
	EndIf

	Do
		$x = FileReadLine($file)
		If @error <> 0 Then ExitLoop
		process_listview_add($aControl[$eidProcess_list][$eControl_data], $x)
	Until @error <> 0

	FileClose($file)
EndFunc   ;==>settings_load

; ##################################################################################################
; Creates 2 controls 1 for Label and 1 for Data Type												#
; ##################################################################################################
; Parameters:
; 1 ByRef $aControl: Control Array to Modify: aControl[control_ID][eControl_data | eControl_label]
; 2 Int $iControl_id: Index of aControl[iControl_id][..] to modify:
; 3 String $sLabel: The label text of the control
; 4 Int $label_x: The position of the Label Control
; 5 Int $label_y: The position of the Label Control
; 6 Int $label_w: The width of the Label Control
; 7 Int $label_h: The height of the Label Control
; 8 String $sData_control_type: The type of the Data Control, "input", "input numonly", "checkbox" see SWITCH CASE(s) below
; 9 Int $data_x: The position of the Data Control
; 10 Int $data_y: The position of the Data Control
; 11 Int $data_w: The Width of the Data Control
; 11 Int $data_h: The Height of the Data Control
; 12 Variant $data_value: Data Control Default Value
Func label_control(ByRef $aControl, $iControl_id, $sLabel, $label_x, $label_y, $label_w, $label_h, $sData_control_type, $data_x, $data_y, $data_w, $data_h, $data_value = "")
	; Create Label Control
	;If $sData_control_type <> 'button' Then
	$aControl[$iControl_id][$eControl_label] = GUICtrlCreateLabel($sLabel, $label_x, $label_y, $label_w, $label_h)
	;EndIf
	; Create Data Control
	Switch $sData_control_type; Select Control Type (function parameter: 8)
		Case 'input'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateInput($data_value, $data_x, $data_y, $data_w, $data_h)
		Case 'input numonly'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateInput($data_value, $data_x, $data_y, $data_w, $data_h, $es_number)
		Case 'input readonly'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateInput($data_value, $data_x, $data_y, $data_w, $data_h)
			GUICtrlSendMsg($aControl[$iControl_id][$eControl_data], $EM_SETREADONLY, 1, 0); Send Readonly Message to the control
		Case 'input readonly center'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateInput($data_value, $data_x, $data_y, $data_w, $data_h, $ES_CENTER)
			GUICtrlSendMsg($aControl[$iControl_id][$eControl_data], $EM_SETREADONLY, 1, 0); Send Readonly Message to the control
		Case 'input password'; Hide Passwords
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateInput($data_value, $data_x, $data_y, $data_w, $data_h, $es_password)
		Case 'checkbox'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateCheckbox("", $data_x, $data_y, $data_w, $data_h)
			If $data_value = $GUI_Checked Then GUICtrlSetState($aControl[$iControl_id][$eControl_data], $gui_checked)
		Case 'combo'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateCombo("", $data_x, $data_y, $data_w, $data_h, $CBS_DROPDOWNLIST)
			;_GUICtrlComboBox_SetCurSel($aControl[$iControl_id][1], $data_value)
		Case 'edit'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateEdit($data_value, $data_x, $data_y, $data_w, $data_h, $WS_VSCROLL)
		Case 'label'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateLabel($data_value, $data_x, $data_y, $data_w, $data_h)
		Case 'label center'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateLabel($data_value, $data_x, $data_y, $data_w, $data_h, $ES_CENTER)
		Case 'listview'
			;Example data_value: "col1        |col2       |col3 "
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateListView($data_value, $data_x, $data_y, $data_w, $data_h, -1, $LVS_EX_CHECKBOXES)
		Case 'button'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateButton($data_value, $data_x, $data_y, $data_w, $data_h)
		Case 'button multiline'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateButton($data_value, $data_x, $data_y, $data_w, $data_h, $BS_MULTILINE)

		Case 'group'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateGroup($data_value, $data_x, $data_y, $data_w, $data_h)
		Case 'hyperlink'
			$aControl[$iControl_id][$eControl_data] = GUICtrlCreateLabel($data_value, $data_x, $data_y, $data_w, $data_h)
			GUICtrlSetColor($aControl[$iControl_id][$eControl_data], 0x0000ff)
	EndSwitch; sData_control_type
	GUICtrlSetTip($aControl[$iControl_id][$eControl_data], $aControl[$iControl_id][$eControl_tip])
EndFunc   ;==>label_control

Func out($output = "")
	ConsoleWrite(@CRLF & $output); To Console new line, value of $output
EndFunc   ;==>out

; Remove Label and Return Data, from File_Line Label Data pair.
; Breaks Label at: ": "
Func read_chunk($file, $sLabel_break = ": ")
	$chunk = FileReadLine($file); Read line string into chunk
	If @error <> 0 Then
		Return "EOF"; End of File Error Reading File
	EndIf
	$chunk_po = StringInStr($chunk, $sLabel_break) ; Find the string position of the first sLabel_break
	Return StringMid($chunk, $chunk_po + StringLen($sLabel_break)) ; Return String after label_break in chunk
EndFunc   ;==>read_chunk

Func window_list($aList_data, $win_title = "", $win_width = 420, $win_height = 300)
	Local $hGui = GUICreate($win_title, $win_width, $win_height, Default, Default, Default, Default, $ghGui)
	Local $gui_rect = WinGetPos($hGui)
	Local $idConfirm_button = GUICtrlCreateButton("Confirm", $gui_rect[2] - 65, $gui_rect[3] - 55, 55, 20)

	$gMylistbox = GUICtrlCreateList("", 0, 5, $gui_rect[2] - 10, $gui_rect[3] - 30)

	For $i = 1 To $aList_data[0][0]
		;if $proglist[$i][0]<>"" then guictrlsetdata($gMylistbox, $proglist[$i][0]&"|")
		GUICtrlSetData($gMylistbox, $aList_data[$i][0] & "|")
	Next
	GUISetState()
	Local $confirm = 0
	Local $return = -1
	Do
		$msg = GUIGetMsg()
		; Select key from list
		If _IsPressed("0d") Or $gMylistbox_msg = 1 Then
			keyreleased("0d")
			$confirm = 1
		EndIf
	Until $msg = $gui_event_close Or $confirm = 1
	If $confirm Then
		$return = GUICtrlRead($gMylistbox)
	EndIf
	$gMylistbox_msg = 0
	GUIDelete($hGui)
	Return $return
EndFunc   ;==>window_list

Func _WM_COMMAND($hWnd, $msg, $wParam, $lParam)
	Local $nCode = BitShift($wParam, 16) ; HiWord
	Local $nIDFrom = BitAND($wParam, 0xFFFF) ; LoWord

	Switch $nIDFrom
		Case $gMylistbox

			Switch $nCode
				Case $LBN_DBLCLK
					$sListItem = GUICtrlRead($gMylistbox) ; Read selected item
					$gMylistbox_msg = 1
			EndSwitch; nCode
	EndSwitch; nIDFrom
	Return $GUI_RUNDEFMSG
EndFunc   ;==>_WM_COMMAND

Func keyreleased($key, $key2 = "", $key3 = "", $key4 = "")
	While _IsPressed($key) Or _IsPressed($key2)
		Sleep(20)
	WEnd
	While _IsPressed($key3) Or _IsPressed($key4)
		Sleep(20)
	WEnd
EndFunc   ;==>keyreleased

Func process_listview_add(ByRef $listview, $sProcess_name)
	GUICtrlCreateListViewItem($sProcess_name, $listview)
	;_GUICtrlListView_AddItem($ghProcess_list, $sProcess_name)
EndFunc   ;==>process_listview_add

Func _exit()
	ToolTip("")
EndFunc   ;==>_exit

Func process_list_suspend(ByRef $aControl)
	GUICtrlSetData($aControl[$eidAction_state][$eControl_data], $gaAction_state[$eAction_state_suspend][$eAction_state_name])
	$num = _GUICtrlListView_GetItemCount($ghProcess_list)
	For $i = 0 To $num
		$text = _GUICtrlListView_GetItemText($ghProcess_list, $i)
		;ConsoleWrite($gaAction_state[$eAction_state_suspend][$eAction_state_name] & " [" & $i & "] " & $text & " " & @SEC & @CRLF)
		_ProcessSuspend($text)
	Next
EndFunc   ;==>process_list_suspend

Func process_list_resume(ByRef $aControl)
	GUICtrlSetData($aControl[$eidAction_state][$eControl_data], $gaAction_state[$eAction_state_resume][$eAction_state_name])
	$num = _GUICtrlListView_GetItemCount($ghProcess_list)
	For $i = 0 To $num - 1
		$text = _GUICtrlListView_GetItemText($ghProcess_list, $i)
		;ConsoleWrite($gaAction_state[$eAction_state_resume][$eAction_state_name] & " [" & $i & "] " & $text & " " & @SEC & @CRLF)
		_ProcessResume($text)
	Next
EndFunc   ;==>process_list_resume

Func process_list_remove()
	$num = _GUICtrlListView_GetItemCount($ghProcess_list)
	For $i = $num - 1 To 0 Step -1
		If _GUICtrlListView_GetItemChecked($ghProcess_list, $i) = $gui_checked Then
			;MsgBox(0, "listview item", _GUICtrlListView_GetItemTextString($ghProcess_list, $i) & "    " & @CRLF & "Line Checked = " & $i)
			_GUICtrlListView_DeleteItem($ghProcess_list, $i)
		EndIf
	Next
EndFunc   ;==>process_list_remove

Func core_temp_get_handle($sCore_temp_win_title)
	Local $hCoretemp = WinGetHandle($sCore_temp_win_title)
	If @error = 0 Then
		Return $hCoretemp
	Else
		MsgBox(0, "Application Not Found", "Core Temp External App not found" & _
				@CRLF & "Please run Core Temp Application" & _
				@CRLF & @CRLF & "Restart this Application after starting Core Temp to use CPU Temperature features" & _
				@CRLF & @CRLF & "You can still use the Action 'Switch' Button to toggle Process Suspended State")
	EndIf; error = 0
	Return Null
EndFunc   ;==>core_temp_get_handle

Func edit_state_toggle(ByRef $aControl, ByRef $iEdit_state)
	Switch $iEdit_state
		Case $eEdit_state_edit
			$iEdit_state = $eEdit_state_react
		Case Else
			$iEdit_state = $eEdit_state_edit
	EndSwitch
	GUICtrlSetData($aControl[$eidCore_temp_edit_status][$eControl_data], $gaEdit_state[$iEdit_state][$eAction_state_name])
	GUICtrlSetBkColor($aControl[$eidCore_temp_edit_status][$eControl_data], $gaEdit_state[$iEdit_state][$eAction_state_color])

	Switch $iEdit_state
		Case $eEdit_state_edit
			$aData = control_cpu_temp($aControl, $gui_enable)
		Case Else
			$aData = control_cpu_temp($aControl, $gui_disable)
	EndSwitch

	Return $aData
EndFunc   ;==>edit_state_toggle

Func control_cpu_temp(ByRef $aControl, $state = $gui_disable)
	Local $aData[$giSettings_offset_before_process_list]
	Switch $state
		Case $gui_disable
			For $i = $eidCore_temp_high To $eidCore_temp_read_timer_max
				GUICtrlSetState($aControl[$i][$eControl_data], $state)
				$aData[$i - $eidCore_temp_high] = int(GUICtrlRead($aControl[$i][$eControl_data]))
			Next
		Case $gui_enable
			For $i = $eidCore_temp_high To $eidCore_temp_read_timer_max
				GUICtrlSetState($aControl[$i][$eControl_data], $state)
				$aData[$i - $eidCore_temp_high] = int(GUICtrlRead($aControl[$i][$eControl_data]))
			Next
	EndSwitch
	$aData[$eData_temp_check_sec] = 1000 * int(GUICtrlRead($aControl[$eidCore_temp_read_timer_max][$eControl_data]))
	Return $aData
EndFunc   ;==>control_cpu_temp

Func about_dialog()
	Local $aControl = [[0, "Programmer:", "label", "Joshua Songer", "AutoIt Forum: Xandy"], _
			[0, "Website:", "hyperlink", "www.songersoft.com", "CTRL + Click to open website"], _
			[0, "", "label", "", ""], _ ; Blank Line
			[0, "Core Temp:", "label", "External Application to Monitor CPU Temperature", "External Application to Monitor CPU Temperature"], _
			[0, "Website:", "hyperlink", "http://core-temp.en.lo4d.com/download", "CTRL + Click to open website"] _
			]

	Local $control_max = UBound($aControl)
	Enum $eAbout_control_programmer, $eAbout_control_website, $eAbout_control_external, $eAbout_control_external_website

	; Gui and rect
	Local $hgui = GUICreate("About: "&@ScriptName, 455, $control_max * 22, Default, Default, Default, Default, $ghGui); Create Sub Window
	Local $gui_rect = wingetpos($hgui)

	; Create GUI Controls
	For $i = 0 To $control_max - 1
		$y = 5 + $i * 21; Calculate the y coord
		label_control($aControl, $i, $aControl[$i][$eControl_label], 5, $y, 100, 20, $aControl[$i][$eControl_type], 110, $y, $gui_rect[2]-15, 20, $aControl[$i][$eControl_data_val])
		GUICtrlSetFont($aControl[$i][$eControl_label], 12)
		GUICtrlSetFont($aControl[$i][$eControl_data], 12)
	Next
	GUISetState(); Show the Gui

	Do
		$msg = GUIGetMsg()
		If _IsPressed(11) Then; CTRL Key Down, Detect hyperlink clicks
			for $i= 0 to $control_max-1
				if $aControl[$i][$eControl_type]= 'hyperlink' then
					if $msg= $aControl[$i][$eControl_data] then
						ShellExecute(guictrlread($aControl[$i][$eControl_data])); Launch the data
						keyreleased(1); One fight per click felles
					endif; gui control
				endif; 'hyperlink'
			next; i .. control_max
		EndIf; CTRL Down
	Until $msg = $gui_event_close
	GUIDelete($hgui)
EndFunc   ;==>about_dialog